<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Conditional Form</title>
<style>
  .conditional-question {
    display: none;
  }
</style>
</head>
<body>

<form id="conditionalForm">
  <label>Select a category:</label><br>
  <input type="radio" name="category" value="plastic"> Plastic<br>
  <input type="radio" name="category" value="rubber"> Rubber<br>

  <div class="conditional-question" id="plasticQuestions">
    <label>Do you need information about recycling plastic?</label><br>
    <input type="radio" name="plasticResponse" value="yes"> Yes<br>
    <input type="radio" name="plasticResponse" value="no"> No<br>

    <div class="conditional-question" id="plasticYes">
      <!-- Additional questions for "Yes" response -->
      <label>Do you want to know about the process of plastic recycling?</label><br>
      <input type="radio" name="plasticRecyclingInfo" value="yes"> Yes<br>
      <input type="radio" name="plasticRecyclingInfo" value="no"> No<br>
      
      <div class="conditional-question" id="plasticRecyclingInfoYes">
        <!-- Additional questions for "Yes" response to plastic recycling info -->
        <label>Would you like to learn about the environmental benefits of plastic recycling?</label><br>
        <input type="radio" name="plasticRecyclingBenefits" value="yes"> Yes<br>
        <input type="radio" name="plasticRecyclingBenefits" value="no"> No<br>
        
        <div class="conditional-question" id="plasticRecyclingBenefitsYes">
          <!-- Additional questions for "Yes" response to plastic recycling benefits -->
          <label>Are you interested in knowing about the economic aspects of plastic recycling?</label><br>
          <input type="radio" name="plasticRecyclingEconomic" value="yes"> Yes<br>
          <input type="radio" name="plasticRecyclingEconomic" value="no"> No<br>
        </div>
      </div>
      
      <div class="conditional-question" id="plasticRecyclingInfoNo">
        <!-- Additional questions for "No" response to plastic recycling info -->
        <label>Are you already familiar with the process of plastic recycling?</label><br>
        <input type="radio" name="plasticRecyclingFamiliar" value="yes"> Yes<br>
        <input type="radio" name="plasticRecyclingFamiliar" value="no"> No<br>
      </div>
    </div>
    
    <div class="conditional-question" id="plasticNo">
      <!-- Additional question for "No" response -->
      <label>Why do you not need information about recycling plastic?</label><br>
      <textarea name="plasticNoReason"></textarea><br>
      
      <div class="conditional-question" id="plasticRecyclingInfoNoFuture">
        <!-- Additional questions for "No" response to plastic recycling info -->
        <label>Would you like to learn about the environmental benefits of plastic recycling in the future?</label><br>
        <input type="radio" name="plasticRecyclingBenefitsFuture" value="yes"> Yes<br>
        <input type="radio" name="plasticRecyclingBenefitsFuture" value="no"> No<br>
      </div>
    </div>
  </div>

  <button type="submit">Submit</button>
</form>

<script>
  document.getElementById('conditionalForm').addEventListener('change', function(event) {
    const selectedCategory = document.querySelector('input[name="category"]:checked');
    if (selectedCategory && selectedCategory.value === "plastic") {
      const plasticQuestions = document.getElementById('plasticQuestions');
      if (plasticQuestions) {
        plasticQuestions.style.display = 'block';
      }
    }
  });

  document.querySelectorAll('input[type="radio"][name="plasticResponse"]').forEach(function(radio) {
    radio.addEventListener('change', function(event) {
      const response = event.target.value;
      const parentQuestion = event.target.closest('.conditional-question');
      if (parentQuestion) {
        parentQuestion.querySelectorAll('.conditional-question').forEach(function(question) {
          question.style.display = 'none';
        });
        const responseQuestions = document.getElementById('plastic' + response.charAt(0).toUpperCase() + response.slice(1));
        if (responseQuestions) {
          responseQuestions.style.display = 'block';
        }
      }
    });
  });

  document.querySelectorAll('input[type="radio"][name="plasticRecyclingInfo"]').forEach(function(radio) {
    radio.addEventListener('change', function(event) {
      const response = event.target.value;
      const parentQuestion = event.target.closest('.conditional-question');
      if (parentQuestion) {
        parentQuestion.querySelectorAll('.conditional-question').forEach(function(question) {
          question.style.display = 'none';
        });
        const responseQuestions = document.getElementById('plasticRecyclingInfo' + response.charAt(0).toUpperCase() + response.slice(1));
        if (responseQuestions) {
          responseQuestions.style.display = 'block';
        }
      }
    });
  });
</script>

</body>
</html>